%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MATLAB code:  Example 6.5
% File: BL_CLS.m  (BL estimation with CLS)
%
% BL: Y_{t} = beta * varepsilon_{t-1} * Y_{t-2} + varepsilon_{t} 
%    with varepsilon_{t} ~ N(0,1) distributed.
% Coverage probabilities: 95% and 90% 
%
% Reference:
% Giordano, F. (2000).
%   The variance of CLS estimators for a simple bilinear model.
%   Quaderni di Statistica, 2(2), 147-155.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
n     = 500;
m     = 100;
iter  = 1000;
beta  = 0.5;
sum1  = 0;
sum2  = 0;

for it=1:iter
    eps  = normrnd(0,1,n+m,1);
    y    = zeros(n+m,1);
    for i=3:n+m
       y(i) = beta*eps(i-1)*y(i-2)+eps(i);
    end;

    data = y(m+1:m+n);

%   Start: CLS estimation    
    y2    = data.*data;
    y2lag = y2(3:n);
    yy    = y2(1:n-2);
    X     = [ones(size(y2lag)) yy];
    a     = X\y2lag;                   % a(1) is estimated LS variance of eps

    num = 0;
    den = 0;
    for i=1:n-2
       num = num + data(i+2)*data(i+1)*data(i);
       den = den + data(i)*data(i);
    end;
    
    best  = (num/(a(1)*den));            % CLS estimate of beta
    cond1 = (best*a(1))^8;
    if (cond1 < (1/105) && a(1) > 0)     % E(Y^{8}_{t})<\infty (normal cconvergence) 
       sum1 = sum1+1;
       betaCLS(sum1,1)   = best;         % estimate of beta
       bCLS(sum1,1)      = best-beta;    % bias of estimator of beta
       VY                = a(1)/(1-best*best*a(1));  % variance series Y_{t}
       vars(sum1,1)      = VY;
       varestCLS(sum1,1) = a(1)*(1+22*(best^2)*a(1)+9*(best^2)*(a(1)^4)-6*(best^2)*VY)/VY;
                           % see Giordano (2000, p. 151)
       varestsigmaCLS(sum1,1) = a(1)-1;  % bias estimator of sigma^2_{\varepsilon}
       varepsilon(sum1,1)     = a(1);    
    end;     
end;    
 
%   OUTPUT CLS 
meanbCLS       = mean(bCLS);                    
stdbestCLS     = mean(sqrt(varestCLS))/sqrt(n);  
meanvarCLS     = mean(varestsigmaCLS);          
meanvarepsilon = mean(varepsilon);           

%%%  Number of times beta is in the 95% CI: betaCLS +/- 1.96* sqrt(varestCLS)
   sum2 = 0;
   for i=1:sum1
      lb1(i)   = betaCLS(i,1) - 1.96* sqrt(varestCLS(i,1))/sqrt(n);
      ub1(i)   = betaCLS(i,1) + 1.96* sqrt(varestCLS(i,1))/sqrt(n);
      ublb1(i) = ub1(i)-lb1(i);
      if (beta >= lb1(i) && beta <= ub1(i)) 
          sum2 = sum2+1;
      end
   end
   Covprob1  = (sum2/sum1);   %  95% coverage probability 
   meanublb1 = mean(ublb1);   %  average length interval
   
   sum3 = 0;
   for i=1:sum1
      lb2(i)   = betaCLS(i,1) - 1.645* sqrt(varestCLS(i,1))/sqrt(n);
      ub2(i)   = betaCLS(i,1) + 1.645* sqrt(varestCLS(i,1))/sqrt(n);
      ublb2(i) = ub2(i)-lb2(i);
      if (beta >= lb2(i) && beta <= ub2(i)) 
          sum3 = sum3+1;
       end
   end
   Covprob2  = (sum3/sum1);  %  90% coverage probability 
   meanublb2 = mean(ublb2);  %  average length interval
   



